% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sigma.R
\name{get_sigma}
\alias{get_sigma}
\title{Extract residual variability parameter estimates from a NONMEM output object.}
\usage{
get_sigma(x, output = "est", sigdig = 6, sep = "-")
}
\arguments{
\item{x}{A NONMEM output object generated using \code{\link{read_nm}}.}

\item{output}{A flag specifying the matrix or matrices to be output. Valid flag values are \code{est} (the default),
\code{se}, \code{rse}, \code{cor}, \code{cse}, \code{95ci}, or \code{all}.}

\item{sigdig}{Specifies the number of significant digits to be provided (default=6).}

\item{sep}{Specifies the separator character to use for 95\% confidence intervals (default="-").}
}
\value{
A symmetrical matrix, or a list of symmetrical matrices if \code{all} is specified.

\code{est} returns the estimated SIGMA variance-covariance matrix.
\code{se} returns the standard errors for the estimated SIGMA variance-covariance matrix.
\code{rse} returns the relative standard errors for the estimated SIGMA variance-covariance matrix (se/est*100).
\code{cor} returns the correlation matrix matrix.
\code{cse} returns the standard errors for the correlation matrix.
\code{95ci} returns the asymptotic 95\% confidence intervals for the elements of the SIGMA variance-covariance
matrix (est +/- 1.96*se).
\code{all} returns all available SIGMA matrices.
}
\description{
Extract residual variability parameter estimates from a NONMEM output object.
}
\examples{
\dontrun{
 nmOutput <- read_nm("run315.xml")
 sigmas   <- get_sigma(nmOutput)
 sigmaRSEs <- get_sigma(nmOutput, "rse")
}

}
\seealso{
NONMEM (\url{http://www.iconplc.com/innovation/nonmem/})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
