% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nmtables.R
\name{read_nmtables}
\alias{read_nmtables}
\title{Reads NONMEM output tables.}
\usage{
read_nmtables(tableFiles = NULL, runNo = NULL, tabSuffix = "",
  tableNames = c("sdtab", "mutab", "patab", "catab", "cotab", "mytab",
  "extra", "xptab"), quiet = FALSE, ...)
}
\arguments{
\item{tableFiles}{NONMEM table files to be read.}

\item{runNo}{Run number.}

\item{tabSuffix}{Table file suffix.}

\item{tableNames}{List of root table names, using the Xpose naming convention as the default.}

\item{quiet}{Flag for displaying intermediate output (defaults to \code{FALSE}).}

\item{...}{Additional arguments.}
}
\value{
A data frame.
}
\description{
Reads NONMEM output tables.
}
\note{
Adapted from Xpose 4 (\url{https://CRAN.R-project.org/package=xpose4}).
}
\examples{
\dontrun{
tables <- read_nmtables(315)
}

}
\seealso{
NONMEM (\url{http://www.iconplc.com/innovation/nonmem/})

Jonsson EN, Karlsson MO. Xpose--an S-PLUS based population pharmacokinetic/pharmacodynamic model building aid for NONMEM. Comput Methods Programs Biomed. 1999 Jan;58(1):51-64
}
\author{
Justin Wilkins, Niclas Jonsson, Andrew Hooker
}
