% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_sigma.R
\name{sample_sigma}
\alias{sample_sigma}
\title{Sample from the multivariate normal distribution using the SIGMA variance-covariance matrix to generate new sets of simulated EPSILONs from NONMEM output.}
\usage{
sample_sigma(nmRun, n, seed)
}
\arguments{
\item{nmRun}{Root filename for the NONMEM run (e.g. "run315").}

\item{n}{Number of samples required.}

\item{seed}{Random seed.}
}
\value{
A data frame containing \code{n} samples from the multivariate normal distribution, using
the estimated NONMEM SIGMA variance-covariance matrix. This provides \code{n} sets of EPSILON estimates
suitable for simulation of new datasets.
}
\description{
Sample from the multivariate normal distribution using the SIGMA variance-covariance matrix to generate new sets of simulated EPSILONs from NONMEM output.
}
\examples{
\dontrun{
 sigDist <- sample_sigma("run315", 5000, seed=740727)
}

}
\seealso{
NONMEM (\url{http://www.iconplc.com/innovation/nonmem/})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
