% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_blq.R
\name{ftrans_blq_linear}
\alias{ftrans_blq_linear}
\alias{ftrans_blq_log}
\title{Forward transformation for linear BLQ data}
\usage{
ftrans_blq_linear(lloq, multiplier)

ftrans_blq_log(lloq, multiplier, base = 10)
}
\arguments{
\item{lloq}{The value of the lower limit of quantification as a numeric
scalar}

\item{multiplier}{When data are \code{< lloq}, they are replaced by
\code{lloq*multiplier} for display.}

\item{base}{The base for the logarithm}
}
\value{
A function of \code{x} that replaces \code{x < lloq} with
  \code{lloq*multiplier}
}
\description{
For ggplot2 scales.
}
\section{Functions}{
\itemize{
\item \code{ftrans_blq_log()}: Log-scale transformation

}}
\seealso{
Other BLQ Transformation: 
\code{\link{blq_trans}()},
\code{\link{breaks_blq_general}()},
\code{\link{estimate_lloq}()},
\code{\link{itrans_blq_linear}()},
\code{\link{label_blq}()}
}
\concept{BLQ Transformation}
