% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_transformers.R
\name{tt_tbl_colnames}
\alias{tt_tbl_colnames}
\title{Table Transformer: get a table's column names}
\usage{
tt_tbl_colnames(tbl)
}
\arguments{
\item{tbl}{A table object to be used as input for the transformation. This
can be a data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object.}
}
\value{
A \code{tibble} object.
}
\description{
With any table object, you can produce a summary table that contains table's
column names. The output summary table will have two columns and as many rows
as there are columns in the input table. The first column is the \code{".param."}
column, which is an integer-based column containing the indices of the
columns from the input table. The second column, \code{"value"}, contains the
column names from the input table.
}
\section{Function ID}{

12-4
}

\examples{
# Get the column names of the
# `game_revenue` dataset that's
# included in the package
tt_tbl_colnames(game_revenue)

# This output table is useful when
# you want to validate the
# column names of the table; here,
# we check that `game_revenue` has
# certain column names present
tt_tbl_colnames(game_revenue) \%>\%
  test_col_vals_make_subset(
    columns = vars(value),
    set = c("acquisition", "country")
  )

# We can check to see whether the
# column names in the `specifications`
# table are all less than 15
# characters in length
specifications \%>\%
  tt_tbl_colnames() \%>\%
  tt_string_info() \%>\%
  test_col_vals_lt(
    columns = vars(value),
    value = 15
  )

}
\seealso{
Other Table Transformers: 
\code{\link{get_tt_param}()},
\code{\link{tt_string_info}()},
\code{\link{tt_summary_stats}()},
\code{\link{tt_tbl_dims}()},
\code{\link{tt_time_shift}()},
\code{\link{tt_time_slice}()}
}
\concept{Table Transformers}
