% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_transformers.R
\name{get_tt_param}
\alias{get_tt_param}
\title{Get a parameter value from a summary table}
\usage{
get_tt_param(tbl, param, column = NULL)
}
\arguments{
\item{tbl}{A summary table generated by either of the \code{\link[=tt_summary_stats]{tt_summary_stats()}},
\code{\link[=tt_string_info]{tt_string_info()}}, \code{\link[=tt_tbl_dims]{tt_tbl_dims()}}, or \code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}} functions.}

\item{param}{The parameter name associated to the value that is to be gotten.
These parameter names are always available in the first column (\code{.param.})
of a summary table obtained by \code{\link[=tt_summary_stats]{tt_summary_stats()}}, \code{\link[=tt_string_info]{tt_string_info()}},
\code{\link[=tt_tbl_dims]{tt_tbl_dims()}}, or \code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}}.}

\item{column}{The column in the summary table for which the data value should
be obtained. This must be supplied for summary tables generated by
\code{\link[=tt_summary_stats]{tt_summary_stats()}} and \code{\link[=tt_string_info]{tt_string_info()}} (the \code{\link[=tt_tbl_dims]{tt_tbl_dims()}} and
\code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}} functions will always generate a two-column summary
table).}
}
\description{
The \code{get_tt_param()} function can help you to obtain a single
parameter value from a summary table generated by the \verb{tt_*()} functions
\code{\link[=tt_summary_stats]{tt_summary_stats()}}, \code{\link[=tt_string_info]{tt_string_info()}}, \code{\link[=tt_tbl_dims]{tt_tbl_dims()}}, or
\code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}}. The following parameters are to be used depending on the
input \code{tbl}:
\itemize{
\item from \code{\link[=tt_summary_stats]{tt_summary_stats()}}: \code{"min"}, \code{"p05"}, \code{"q_1"}, \code{"med"}, \code{"q_3"},
\code{"p95"}, \code{"max"}, \code{"iqr"}, \code{"range"}
\item from \code{\link[=tt_string_info]{tt_string_info()}}: \code{"length_mean"}, \code{"length_min"}, \code{"length_max"}
\item from \code{\link[=tt_tbl_dims]{tt_tbl_dims()}}: \code{"rows"}, \code{"columns"}
\item from \code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}}: any integer present in the \code{.param.} column
}

The \code{\link[=tt_summary_stats]{tt_summary_stats()}} and \code{\link[=tt_string_info]{tt_string_info()}} functions will generate
summary tables with columns that mirror the numeric and character columns
in their input tables, respectively. For that reason, a column name must be
supplied to the \code{column} argument in \code{get_tt_param()}.
}
\section{Examples}{


Get summary statistics for the first quarter of the \code{game_revenue} dataset
that's included in the \strong{pointblank} package.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{stats_tbl <- 
  game_revenue \%>\%
  tt_time_slice(slice_point = 0.25) \%>\%
  tt_summary_stats()
  
stats_tbl
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 9 × 3
##   .param. item_revenue session_duration
##   <chr>          <dbl>            <dbl>
## 1 min             0.02              5.1
## 2 p05             0.03             11  
## 3 q_1             0.08             17.2
## 4 med             0.28             28.3
## 5 q_3             1.37             32  
## 6 p95            40.0              37.1
## 7 max           143.               41  
## 8 iqr             1.28             14.8
## 9 range         143.               35.9
}\if{html}{\out{</div>}}

Sometimes you need a single value from the table generated by the
\code{\link[=tt_summary_stats]{tt_summary_stats()}} function. For that, we can use the \code{get_tt_param()}
function. So if we wanted to test whether the maximum session duration during
the rest of the time period (the remaining 0.75) is never higher than that of
the first quarter of the year, we can supply a value from \code{stats_tbl} to
\code{\link[=test_col_vals_lte]{test_col_vals_lte()}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{game_revenue \%>\%
  tt_time_slice(
    slice_point = 0.25,
    keep = "right"
  ) \%>\%
  test_col_vals_lte(
    columns = vars(session_duration), 
    value = get_tt_param(
      tbl = stats_tbl,
      param = "max",
      column = "session_duration"
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] TRUE
}\if{html}{\out{</div>}}
}

\section{Function ID}{

12-7
}

\seealso{
Other Table Transformers: 
\code{\link{tt_string_info}()},
\code{\link{tt_summary_stats}()},
\code{\link{tt_tbl_colnames}()},
\code{\link{tt_tbl_dims}()},
\code{\link{tt_time_shift}()},
\code{\link{tt_time_slice}()}
}
\concept{Table Transformers}
