% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_is_character.R
\name{col_is_character}
\alias{col_is_character}
\alias{expect_col_is_character}
\alias{test_col_is_character}
\title{Do the columns contain character/string data?}
\usage{
col_is_character(
  x,
  columns,
  actions = NULL,
  step_id = NULL,
  label = NULL,
  brief = NULL,
  active = TRUE
)

expect_col_is_character(object, columns, threshold = 1)

test_col_is_character(object, columns, threshold = 1)
}
\arguments{
\item{x}{A data frame, tibble (\code{tbl_df} or \code{tbl_dbi}), Spark DataFrame
(\code{tbl_spark}), or, an \emph{agent} object of class \code{ptblank_agent} that is
created with \code{\link[=create_agent]{create_agent()}}.}

\item{columns}{The column (or a set of columns, provided as a character
vector) to which this validation should be applied.}

\item{actions}{A list containing threshold levels so that the validation step
can react accordingly when exceeding the set levels. This is to be created
with the \code{\link[=action_levels]{action_levels()}} helper function.}

\item{step_id}{One or more optional identifiers for the single or multiple
validation steps generated from calling a validation function. The use of
step IDs serves to distinguish validation steps from each other and provide
an opportunity for supplying a more meaningful label compared to the step
index. By default this is \code{NULL}, and \strong{pointblank} will automatically
generate the step ID value (based on the step index) in this case. One or
more values can be provided, and the exact number of ID values should (1)
match the number of validation steps that the validation function call will
produce (influenced by the number of \code{columns} provided), (2) be an ID
string not used in any previous validation step, and (3) be a vector with
unique values.}

\item{label}{An optional label for the validation step. This label appears in
the \emph{agent} report and for the best appearance it should be kept short.}

\item{brief}{An optional, text-based description for the validation step. If
nothing is provided here then an \emph{autobrief} is generated by the \emph{agent},
using the language provided in \code{\link[=create_agent]{create_agent()}}'s \code{lang} argument (which
defaults to \code{"en"} or English). The \emph{autobrief} incorporates details of the
validation step so it's often the preferred option in most cases (where a
\code{label} might be better suited to succinctly describe the validation).}

\item{active}{A logical value indicating whether the validation step should
be active. If the validation function is working with an \emph{agent}, \code{FALSE}
will make the validation step inactive (still reporting its presence and
keeping indexes for the steps unchanged). If the validation function will
be operating directly on data (no \emph{agent} involvement), then any step with
\code{active = FALSE} will simply pass the data through with no validation
whatsoever. Aside from a logical vector, a one-sided R formula using a
leading \code{~} can be used with \code{.} (serving as the input data table) to
evaluate to a single logical value. With this approach, the \strong{pointblank}
function \code{\link[=has_columns]{has_columns()}} can be used to determine whether to make a
validation step active on the basis of one or more columns existing in the
table (e.g., \code{~ . \%>\% has_columns(vars(d, e))}). The default for \code{active}
is \code{TRUE}.}

\item{object}{A data frame, tibble (\code{tbl_df} or \code{tbl_dbi}), or Spark
DataFrame (\code{tbl_spark}) that serves as the target table for the expectation
function or the test function.}

\item{threshold}{A simple failure threshold value for use with the
expectation (\code{expect_}) and the test (\code{test_}) function variants. By
default, this is set to \code{1} meaning that any single unit of failure in data
validation results in an overall test failure. Whole numbers beyond \code{1}
indicate that any failing units up to that absolute threshold value will
result in a succeeding \strong{testthat} test or evaluate to \code{TRUE}. Likewise,
fractional values (between \code{0} and \code{1}) act as a proportional failure
threshold, where \code{0.15} means that 15 percent of failing test units results
in an overall test failure.}
}
\value{
For the validation function, the return value is either a
\code{ptblank_agent} object or a table object (depending on whether an agent
object or a table was passed to \code{x}). The expectation function invisibly
returns its input but, in the context of testing data, the function is
called primarily for its potential side-effects (e.g., signaling failure).
The test function returns a logical value.
}
\description{
The \code{col_is_character()} validation function, the \code{expect_col_is_character()}
expectation function, and the \code{test_col_is_character()} test function all
check whether one or more columns in a table is of the character type. Like
many of the \verb{col_is_*()}-type functions in \strong{pointblank}, the only
requirement is a specification of the column names. The validation function
can be used directly on a data table or with an \emph{agent} object (technically,
a \code{ptblank_agent} object) whereas the expectation and test functions can only
be used with a data table. Each validation step or expectation will operate
over a single test unit, which is whether the column is a character-type
column or not.
}
\section{Supported Input Tables}{

The types of data tables that are officially supported are:
\itemize{
\item data frames (\code{data.frame}) and tibbles (\code{tbl_df})
\item Spark DataFrames (\code{tbl_spark})
\item the following database tables (\code{tbl_dbi}):
\itemize{
\item \emph{PostgreSQL} tables (using the \code{RPostgres::Postgres()} as driver)
\item \emph{MySQL} tables (with \code{RMySQL::MySQL()})
\item \emph{Microsoft SQL Server} tables (via \strong{odbc})
\item \emph{BigQuery} tables (using \code{bigrquery::bigquery()})
\item \emph{DuckDB} tables (through \code{duckdb::duckdb()})
\item \emph{SQLite} (with \code{RSQLite::SQLite()})
}
}

Other database tables may work to varying degrees but they haven't been
formally tested (so be mindful of this when using unsupported backends with
\strong{pointblank}).
}

\section{Column Names}{

If providing multiple column names, the result will be an expansion of
validation steps to that number of column names (e.g., \code{vars(col_a, col_b)}
will result in the entry of two validation steps). Aside from column names in
quotes and in \code{vars()}, \strong{tidyselect} helper functions are available for
specifying columns. They are: \code{starts_with()}, \code{ends_with()}, \code{contains()},
\code{matches()}, and \code{everything()}.
}

\section{Actions}{

Often, we will want to specify \code{actions} for the validation. This argument,
present in every validation function, takes a specially-crafted list object
that is best produced by the \code{\link[=action_levels]{action_levels()}} function. Read that function's
documentation for the lowdown on how to create reactions to above-threshold
failure levels in validation. The basic gist is that you'll want at least a
single threshold level (specified as either the fraction of test units
failed, or, an absolute value), often using the \code{warn_at} argument. This is
especially true when \code{x} is a table object because, otherwise, nothing
happens. For the \verb{col_is_*()}-type functions, using \code{action_levels(warn_at = 1)} or \code{action_levels(stop_at = 1)} are good choices depending on the
situation (the first produces a warning, the other will \code{stop()}).
}

\section{Briefs}{

Want to describe this validation step in some detail? Keep in mind that this
is only useful if \code{x} is an \emph{agent}. If that's the case, \code{brief} the agent
with some text that fits. Don't worry if you don't want to do it. The
\emph{autobrief} protocol is kicked in when \code{brief = NULL} and a simple brief will
then be automatically generated.
}

\section{YAML}{

A \strong{pointblank} agent can be written to YAML with \code{\link[=yaml_write]{yaml_write()}} and the
resulting YAML can be used to regenerate an agent (with \code{\link[=yaml_read_agent]{yaml_read_agent()}})
or interrogate the target table (via \code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}). When
\code{col_is_character()} is represented in YAML (under the top-level \code{steps} key
as a list member), the syntax closely follows the signature of the validation
function. Here is an example of how a complex call of \code{col_is_character()} as
a validation step is expressed in R code and in the corresponding YAML
representation.

R statement:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent \%>\% 
  col_is_character(
    columns = vars(a),
    actions = action_levels(warn_at = 0.1, stop_at = 0.2),
    label = "The `col_is_character()` step.",
    active = FALSE
  )
}\if{html}{\out{</div>}}

YAML representation:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{steps:
- col_is_character:
    columns: vars(a)
    actions:
      warn_fraction: 0.1
      stop_fraction: 0.2
    label: The `col_is_character()` step.
    active: false
}\if{html}{\out{</div>}}

In practice, both of these will often be shorter as only the \code{columns}
argument requires a value. Arguments with default values won't be written to
YAML when using \code{\link[=yaml_write]{yaml_write()}} (though it is acceptable to include them with
their default when generating the YAML by other means). It is also possible
to preview the transformation of an agent to YAML without any writing to disk
by using the \code{\link[=yaml_agent_string]{yaml_agent_string()}} function.
}

\section{Examples}{


For all examples here, we'll use a simple table with a numeric column (\code{a})
and a character column (\code{b}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <-
  dplyr::tibble(
    a = c(5, 7, 6, 5, 8, 7),
    b = LETTERS[1:6]
  )

tbl
#> # A tibble: 6 x 2
#>       a b    
#>   <dbl> <chr>
#> 1     5 A    
#> 2     7 B    
#> 3     6 C    
#> 4     5 D    
#> 5     8 E    
#> 6     7 F
}\if{html}{\out{</div>}}

We'll use this table with the different function variants.
\subsection{A: Using an \code{agent} with validation functions and then \code{interrogate()}}{

Validate that column \code{b} has the \code{character} class.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <-
  create_agent(tbl = tbl) \%>\%
  col_is_character(columns = vars(b)) \%>\%
  interrogate()
}\if{html}{\out{</div>}}

Printing the \code{agent} in the console shows the validation report in the
Viewer. Here is an excerpt of validation report, showing the single entry
that corresponds to the validation step demonstrated here.

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rich-iannone/pointblank/main/images/man_col_is_character_1.png" alt="This image was generated from the first code example in the `col_is_character()` help file." style="width:100\%;">
}
}
}

\subsection{B: Using the validation function directly on the data (no \code{agent})}{

This way of using validation functions acts as a data filter. Data is passed
through but should \code{stop()} if there is a single test unit failing. The
behavior of side effects can be customized with the \code{actions} option.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\% 
  col_is_character(columns = vars(b)) \%>\%
  dplyr::slice(1:5)
#> # A tibble: 5 x 2
#>       a b    
#>   <dbl> <chr>
#> 1     5 A    
#> 2     7 B    
#> 3     6 C    
#> 4     5 D    
#> 5     8 E
}\if{html}{\out{</div>}}
}

\subsection{C: Using the expectation function}{

With the \verb{expect_*()} form, we would typically perform one validation at a
time. This is primarily used in \strong{testthat} tests.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{expect_col_is_character(tbl, columns = vars(b))
}\if{html}{\out{</div>}}
}

\subsection{D: Using the test function}{

With the \verb{test_*()} form, we should get a single logical value returned to
us.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\% test_col_is_character(columns = vars(b))
#> [1] TRUE
}\if{html}{\out{</div>}}
}
}

\section{Function ID}{

2-22
}

\seealso{
Other validation functions: 
\code{\link{col_count_match}()},
\code{\link{col_exists}()},
\code{\link{col_is_date}()},
\code{\link{col_is_factor}()},
\code{\link{col_is_integer}()},
\code{\link{col_is_logical}()},
\code{\link{col_is_numeric}()},
\code{\link{col_is_posix}()},
\code{\link{col_schema_match}()},
\code{\link{col_vals_between}()},
\code{\link{col_vals_decreasing}()},
\code{\link{col_vals_equal}()},
\code{\link{col_vals_expr}()},
\code{\link{col_vals_gte}()},
\code{\link{col_vals_gt}()},
\code{\link{col_vals_in_set}()},
\code{\link{col_vals_increasing}()},
\code{\link{col_vals_lte}()},
\code{\link{col_vals_lt}()},
\code{\link{col_vals_make_set}()},
\code{\link{col_vals_make_subset}()},
\code{\link{col_vals_not_between}()},
\code{\link{col_vals_not_equal}()},
\code{\link{col_vals_not_in_set}()},
\code{\link{col_vals_not_null}()},
\code{\link{col_vals_null}()},
\code{\link{col_vals_regex}()},
\code{\link{col_vals_within_spec}()},
\code{\link{conjointly}()},
\code{\link{row_count_match}()},
\code{\link{rows_complete}()},
\code{\link{rows_distinct}()},
\code{\link{serially}()},
\code{\link{specially}()},
\code{\link{tbl_match}()}
}
\concept{validation functions}
