% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{snip_highest}
\alias{snip_highest}
\title{A \code{fn} for \code{info_snippet()}: get the highest value from a column}
\usage{
snip_highest(column)
}
\arguments{
\item{column}{The name of the column that contains the target values.}
}
\value{
A formula needed for \code{\link[=info_snippet]{info_snippet()}}'s \code{fn} argument.
}
\description{
The \code{snip_lowest()} function can be used as an \code{\link[=info_snippet]{info_snippet()}} function
(i.e., provided to \code{fn}) to get the highest numerical, time value, or
alphabetical value from a column in the target table.
}
\section{Function ID}{

3-9
}

\examples{
# Generate an informant object, add
# a snippet with `info_snippet()`
# and `snip_highest()` (giving us a
# method to get the highest value in
# column `a`); define a location for
# the snippet result in `{ }` and
# then `incorporate()` the snippet
# into the info text
informant <- 
  create_informant(
    read_fn = ~ small_table,
    tbl_name = "small_table",
    label = "An example."
  ) \%>\% 
  info_columns(
    columns = "a",
    `Highest Value` = "Highest value is {highest_a}."
  ) \%>\%
  info_snippet(
    snippet_name = "highest_a",
    fn = snip_highest(column = "a")
  ) \%>\%
  incorporate()

# We can print the `informant` object
# to see the information report

}
\seealso{
Other Information Functions: 
\code{\link{info_columns_from_tbl}()},
\code{\link{info_columns}()},
\code{\link{info_section}()},
\code{\link{info_snippet}()},
\code{\link{info_tabular}()},
\code{\link{snip_list}()},
\code{\link{snip_lowest}()},
\code{\link{snip_stats}()}
}
\concept{Information Functions}
