% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/approxMargMLE.r
\name{approxMargMLE}
\alias{approxMargMLE}
\title{Compute the marginal MLE of phi}
\usage{
approxMargMLE(data, N1, N2, N01, N02, l = 0, u = 1000, out = c("par",
  "all"), tol = 1e-10)
}
\arguments{
\item{data}{the vector of counts of the fallible data (z11, z12, z21, z22) followed by the infallible data (m011, m012, m021, m022, y01, y02)}

\item{N1}{the opportunity size of group 1 for the fallible data}

\item{N2}{the opportunity size of group 2 for the fallible data}

\item{N01}{the opportunity size of group 1 for the infallible data}

\item{N02}{the opportunity size of group 2 for the infallible data}

\item{l}{the lower end of the range of possible phi's (for optim)}

\item{u}{the upper end of the range of possible phi's (for optim)}

\item{out}{"par" or "all" (for the output of optim)}

\item{tol}{tolerance parameter for the rmle EM algorithm}
}
\value{
a named vector containing the marginal mle of phi
}
\description{
Compute the marginal MLE of the ratio of two Poisson rates in a two-sample Poisson rate problem with misclassified data given fallible and infallible datasets.
}
\examples{
\dontrun{

# small example
z11 <- 34; z12 <- 35; N1 <- 10;
z21 <- 22; z22 <- 31; N2 <- 10;
m011 <- 9; m012 <- 1; y01 <- 3; N01 <- 3;
m021 <- 8; m022 <- 8; y02 <- 2; N02 <- 3;
data <- c(z11, z12, z21, z22, m011, m012, m021, m022, y01, y02)

fullMLE(data, N1, N2, N01, N02)
margMLE(data, N1, N2, N01, N02)
approxMargMLE(data, N1, N2, N01, N02)



# big example :
z11 <- 477; z12 <- 1025; N1 <- 16186;
z21 <- 255; z22 <- 1450; N2 <- 18811;
m011 <- 38;  m012 <- 90; y01 <- 15; N01 <- 1500;
m021 <- 41; m022 <- 200; y02 <-  9; N02 <- 2500;
data <- c(z11, z12, z21, z22, m011, m012, m021, m022, y01, y02)

fullMLE(data, N1, N2, N01, N02)
# margMLE(data, N1, N2, N01, N02) # ~1 min
approxMargMLE(data, N1, N2, N01, N02)



}
}

