% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_with_time_unit}
\alias{ExprDT_with_time_unit}
\alias{(Expr)$dt$with_time_unit}
\title{with_time_unit}
\format{
function
}
\arguments{
\item{tu}{string option either 'ns', 'us', or 'ms'}
}
\value{
Expr of i64
}
\description{
Set time unit of a Series of dtype Datetime or Duration.
This does not modify underlying data, and should be used to fix an incorrect time unit.
The corresponding global timepoint will change.
}
\examples{
df = pl$DataFrame(
  date = pl$date_range(
    low = as.Date("2001-1-1"),
    high = as.Date("2001-1-3"),
    interval = "1d",
    lazy = FALSE
  )
)
df$select(
  pl$col("date"),
  pl$col("date")$dt$with_time_unit()$alias("with_time_unit_ns"),
  pl$col("date")$dt$with_time_unit(tu = "ms")$alias("with_time_unit_ms")
)
}
\keyword{ExprDT}
