% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sign_in_ui_default.R
\name{sign_in_ui_default}
\alias{sign_in_ui_default}
\title{Default UI styles for the sign-in pages}
\usage{
sign_in_ui_default(
  sign_in_module = sign_in_module_ui("sign_in"),
  color = "#5ec7dd",
  company_name = "Your Brand Here",
  logo_top = tags$div(style = "width: 300px; max-width: 100\%; color: #FFF;", class =
    "text-center", h1("Your", style = "margin-bottom: 0; margin-top: 30px;"), h1("Brand",
    style = "margin-bottom: 0; margin-top: 10px;"), h1("Here", style =
    "margin-bottom: 15px; margin-top: 10px;")),
  logo_bottom = NULL,
  icon_href = "polish/images/polished_icon.png",
  background_image = NULL,
  terms_and_privacy_footer = NULL,
  align = "center"
)
}
\arguments{
\item{sign_in_module}{UI module for the sign in and registration pages.}

\item{color}{hex color for the background and button.}

\item{company_name}{your company name.}

\item{logo_top}{html for logo to go above the sign in panel.}

\item{logo_bottom}{html for the logo below the sign in panel.}

\item{icon_href}{the url/path to the browser tab icon.}

\item{background_image}{the url/path to a full width background image.  If set to NULL,
the default, the \code{color} argument will be used for the background instead of this
image.}

\item{terms_and_privacy_footer}{links to place in the footer, directly above the copyright
notice.}

\item{align}{The horizontal alignment of the sign in box. Defaults to "center". Valid
values are "left", "center", or "right"}
}
\value{
the UI for the sign in page
}
\description{
Default styling for the sign in and registration pages.  Update the \code{sign_in_ui_default()}
arguments with your brand and colors to quickly style the sign in and registration
pages to match your brand.
}
