% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\docType{data}
\name{Corpus}
\alias{Corpus}
\title{Corpus class.}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Corpus
}
\description{
The R6 \code{Corpus} class offers a set of methods to retrieve and manage CWB
indexed corpora.
}
\section{Fields}{

\describe{
\item{\code{corpus}}{character vector (length 1), a CWB corpus}

\item{\code{encoding}}{encoding of the corpus (typically 'UTF-8' or 'latin1'), assigned
automatically upon initialization of the corpus}

\item{\code{cpos}}{a two-column \code{matrix} with regions of a corpus underlying the
s-attributes of the \code{data.table} in field \code{s_attributes}}

\item{\code{s_attributes}}{a \code{data.table} with the values of a set of s-attributes}

\item{\code{stat}}{a \code{data.table} with counts}
}}

\section{Arguments}{

\describe{
  \item{corpus}{a corpus}
  \item{registryDir}{the directory where the registry file resides}
  \item{dataDir}{the data directory of the corpus}
  \item{p_attribute}{p-attribute, to perform count}
  \item{s_attributes}{s-attributes}
  \item{decode}{logical, whether to turn token ids into strings upon counting}
  \item{as.html}{logical}
}
}

\section{Methods}{

\describe{
  \item{\code{initialize(corpus, p_attribute = NULL, s_attributes = NULL)}}{Initialize a new object of class \code{Corpus}.}
  \item{\code{count(p_attribute = getOption("polmineR.p_attribute"), decode = TRUE)}}{Perform counts.}
  \item{\code{as.partition()}}{turn \code{Corpus} into a partition}
  \item{\code{getInfo(as.html = FALSE)}}{}
  \item{\code{showInfo()}}{}
}
}

\examples{
use("polmineR")
REUTERS <- Corpus$new("REUTERS")
infofile <- REUTERS$getInfo()
if (interactive()) REUTERS$showInfo()

# use Corpus class to manage counts
REUTERS <- Corpus$new("REUTERS", p_attribute = "word")
REUTERS$stat

# use Corpus class for creating partitions
REUTERS <- Corpus$new("REUTERS", s_attributes = c("id", "places"))
usa <- partition(REUTERS, places = "usa")
sa <- partition(REUTERS, places = "saudi-arabia", regex = TRUE)

reut <- REUTERS$as.partition()
}
\keyword{datasets}
