% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hits_class.R
\docType{class}
\name{hits-class}
\alias{hits}
\alias{hits,character-method}
\alias{hits,partition-method}
\alias{hits,partitionBundle-method}
\alias{hits-class}
\alias{sample,hits-method}
\title{Get Hits.}
\usage{
hits(.Object, ...)

\S4method{hits}{character}(.Object, query, cqp = FALSE, sAttribute = NULL,
  pAttribute = "word", size = FALSE, freq = FALSE, mc = FALSE,
  verbose = TRUE, progress = TRUE)

\S4method{hits}{partition}(.Object, query, cqp = FALSE, sAttribute = NULL,
  pAttribute = "word", size = FALSE, freq = FALSE, mc = FALSE,
  progress = FALSE, verbose = TRUE)

\S4method{hits}{partitionBundle}(.Object, query,
  pAttribute = getOption("polmineR.pAttribute"), size = TRUE,
  freq = FALSE, mc = getOption("polmineR.mc"), progress = FALSE,
  verbose = TRUE)

\S4method{sample}{hits}(x, size)
}
\arguments{
\item{.Object}{a character, partition or partitionBundle object}

\item{...}{further parameters}

\item{query}{a (optionally named, see datails) character vector with one or more queries}

\item{cqp}{either logical (TRUE if query is a CQP query), or a
function to check whether query is a CQP query or not}

\item{sAttribute}{s-attributes}

\item{pAttribute}{p-attribute (will be passed into cpos)}

\item{size}{logical - return size of subcorpus}

\item{freq}{logcial - return relative frequencies}

\item{mc}{logical, whether to use multicore}

\item{verbose}{logical}

\item{progress}{logical, whether to show progress bar}

\item{x}{a hits object}
}
\description{
Get hits for a (set of) queries, optionally with s-attribute values.
}
\details{
If the query character vector is named, the names of the query occurr in
the data.table that is returned rather than the queries.

If freq is TRUE, the data.table returned in the DT-slot will deliberately
include the subsets of the partition/corpus with no hits (query is NA,
count is 0).
}
\section{Slots}{

\describe{
\item{\code{dt}}{a \code{"data.table"}}

\item{\code{corpus}}{a \code{"character"} vector}

\item{\code{query}}{Object of class \code{"character"}}
}}

