% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{SNSN_LOD_deviations}
\alias{SNSN_LOD_deviations}
\title{Identify deviations in LOD scores between pairs of simplex x nulliplex markers}
\usage{
SNSN_LOD_deviations(linkage_df, ploidy, N, plot_expected = TRUE,
  alpha = c(0.05, 0.2), phase = c("coupling", "repulsion"))
}
\arguments{
\item{linkage_df}{A linkage data.frame as output of \code{\link{linkage}}.}

\item{ploidy}{Integer. The ploidy level of the species.}

\item{N}{Numeric. The number of F1 individuals in the mapping population.}

\item{plot_expected}{Logical. Plot the observed and expected relationship between r and LOD.}

\item{alpha}{Numeric. Vector of upper and lower tolerances around expected line.}

\item{phase}{Character string. Specify which phase to examine for deviations (usually this is "coupling" phase).}
}
\value{
A vector of deviations in LOD scores outside the range defined by tolerances input \code{alpha}
}
\description{
\code{SNSN_LOD_deviations} checks whether the LOD scores obtained in the case of pairs of simplex x nulliple
markers are compatible with expectation. This can help identify problematic linkage estimates which can adversely affect
marker clustering.
}
\examples{
data("SN_SN_P1")
SNSN_LOD_deviations(SN_SN_P1,ploidy = 4, N = 198)
}
