% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{impute_dosages}
\alias{impute_dosages}
\title{Re-estimate marker dosages given IBD input estimated using a high error prior.}
\usage{
impute_dosages(
  IBD_list,
  dosage_matrix,
  parent1 = "P1",
  parent2 = "P2",
  rounding_error = 0.05,
  min_error_prior = 0.5,
  verbose = TRUE
)
}
\arguments{
\item{IBD_list}{List of IBD probabilities}

\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns. Note that probabilistic genotypes are not currently catered for here.}

\item{parent1}{The identifier of parent 1, by default "P1"}

\item{parent2}{The identifier of parent 2, by default "P2"}

\item{rounding_error}{The maximum deviation from an integer value that an inputed value can have, by default 0.05. For example, an imputed
score of 2.97 or 3.01 would both be rounded to a dosage of 3, while 2.87 would be deemed too far from an integer score, and would be made missing.
If you find the output contains too many missing values, a possibility would be to increase the \code{rounding_error}. However this may
also introduce more errors in the output!}

\item{min_error_prior}{Suggestion for a suitably high error prior to be used in IBD calculations to ensure IBD smoothing is achieved}

\item{verbose}{Should messages be written to standard output?}
}
\description{
Function to correct marker dosage scores given a list of previously estimated IBD probabilities. This may
prove useful to correct genotyping errors. Running the \code{\link{estimate_IBD}} function with a high error prior (e.g. 0.6) will 
result in suppressed predictions of double recombination events, associated with genotyping errors. By forcing the HMM to penalise 
double recombinations heavily, a smoothed haplotype landscape is achieved in which individual genotype observations are down-weighted. 
This smoothed output is then used to re-estimate marker dosages, dependent on (correct) parental scores.
}
\examples{
\dontrun{
# Toy example only, as this will result in an Error: the original error prior was too low
data("IBD_4x","SNP_dosages.4x")
impute_dosages(IBD_list=IBD_4x,dosage_matrix=SNP_dosages.4x)
}
}
