% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{segMaker}
\alias{segMaker}
\title{Create a list of possible QTL segregation types}
\usage{
segMaker(ploidy, segtypes, modes = c("a", "d"))
}
\arguments{
\item{ploidy}{The ploidy of the population. Currently assumed to be an even number for this function.}

\item{segtypes}{List of QTL segregation types to consider,
so e.g. c(1,0) would mean all possible simplex x nulliplex QTL (ie. 4 QTL, on each of homologues 1 - 4 of parent 1).
Note that symmetrical QTL types that cannot be distinguished are not automatically removed and need to be manually identified.
If this is an issue, use the inbuilt list for tetraploids provided with the package to search the full model space.
Such an inbuilt list is currently only available for tetraploids, and is available from the \code{\link{exploreQTL}} function.}

\item{modes}{Character vector of modes of QTL action to consider, with options "a" for "additive" and "d" for dominant QTL action.}
}
\description{
Function to generate list of segregation types for the \code{\link{exploreQTL}} function
}
