% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{estimate_GIC}
\alias{estimate_GIC}
\title{Estimate the Genotypic Information Coefficient (GIC)}
\usage{
estimate_GIC(IBD_list)
}
\arguments{
\item{IBD_list}{List of IBD probabilities}
}
\value{
A nested list; each list element (per linkage group) contains the following items:
\describe{
\item{GIC : }{Matrix of GIC values estimated from the IBD probabilities}
\item{map : }{Integrated linkage map positions of markers used in IBD calculation}
\item{parental_phase : }{The parental marker phasing, coded in 1 and 0's}
}
}
\description{
Function to estimate the GIC per homologue using IBD probabilities
}
\examples{
data("IBD_4x")
GIC_4x <- estimate_GIC(IBD_list = IBD_4x)
}
