% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{rinit}
\alias{rinit}
\alias{rinit,ANY-method}
\alias{rinit,missing-method}
\alias{rinit,pomp-method}
\title{rinit}
\usage{
\S4method{rinit}{pomp}(object, params, t0, nsim = 1, ...)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{t0}{the initial time, i.e., the time corresponding to the initial-state distribution.}

\item{nsim}{optional integer; the number of initial states to simulate per column of \code{params}.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{rinit} returns an \code{nvar} x \code{nsim*ncol(params)} matrix of state-process initial conditions when given an \code{npar} x \code{nsim} matrix of parameters, \code{params}, and an initial time \code{t0}.
By default, \code{t0} is the initial time defined when the \sQuote{pomp} object ws constructed.
}
\description{
Samples from the initial-state distribution.
}
\seealso{
Specification of the initial-state distribution: \link{rinit specification}

More on \pkg{pomp} workhorse functions: 
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{emeasure}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{vmeasure}()},
\code{\link{workhorses}}
}
\concept{extending the pomp package}
\concept{low-level interface}
\concept{pomp workhorses}
