% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_probes.R
\name{basic_probes}
\alias{basic_probes}
\alias{probe_mean}
\alias{probe_median}
\alias{probe_var}
\alias{probe_sd}
\alias{probe_period}
\alias{probe_quantile}
\alias{probe_acf}
\alias{probe_ccf}
\alias{probe_marginal}
\alias{probe_nlar}
\title{Useful probes for partially-observed Markov processes}
\usage{
probe_mean(var, trim = 0, transform = identity, na.rm = TRUE)

probe_median(var, na.rm = TRUE)

probe_var(var, transform = identity, na.rm = TRUE)

probe_sd(var, transform = identity, na.rm = TRUE)

probe_period(var, kernel.width, transform = identity)

probe_quantile(var, probs, ...)

probe_acf(
  var,
  lags,
  type = c("covariance", "correlation"),
  transform = identity
)

probe_ccf(
  vars,
  lags,
  type = c("covariance", "correlation"),
  transform = identity
)

probe_marginal(var, ref, order = 3, diff = 1, transform = identity)

probe_nlar(var, lags, powers, transform = identity)
}
\arguments{
\item{var, vars}{character; the name(s) of the observed variable(s).}

\item{trim}{the fraction of observations to be trimmed (see \code{\link{mean}}).}

\item{transform}{transformation to be applied to the data before the probe is computed.}

\item{na.rm}{if \code{TRUE}, remove all NA observations prior to computing the probe.}

\item{kernel.width}{width of modified Daniell smoothing kernel to be used
in power-spectrum computation: see \code{\link[stats]{kernel}}.}

\item{probs}{the quantile or quantiles to compute: see \code{\link{quantile}}.}

\item{...}{additional arguments passed to the underlying algorithms.}

\item{lags}{In \code{probe_ccf}, a vector of lags between time series.
Positive lags correspond to \code{x} advanced relative to \code{y};
negative lags, to the reverse.

In \code{probe_nlar}, a vector of lags present in the nonlinear
autoregressive model that will be fit to the actual and simulated data.
See Details, below, for a precise description.}

\item{type}{Compute autocorrelation or autocovariance?}

\item{ref}{empirical reference distribution.  Simulated data will be
regressed against the values of \code{ref}, sorted and, optionally,
differenced.  The resulting regression coefficients capture information
about the shape of the marginal distribution.  A good choice for \code{ref}
is the data itself.}

\item{order}{order of polynomial regression.}

\item{diff}{order of differencing to perform.}

\item{powers}{the powers of each term (corresponding to \code{lags}) in the
the nonlinear autoregressive model that will be fit to the actual and
simulated data.  See Details, below, for a precise description.}
}
\value{
A call to any one of these functions returns a probe function,
suitable for use in \code{\link{probe}} or \code{\link{probe_objfun}}.  That
is, the function returned by each of these takes a data array (such as
comes from a call to \code{\link{obs}}) as input and returns a single
numerical value.
}
\description{
Several simple and configurable probes are provided with in the package.
These can be used directly and as templates for custom probes.
}
\references{
\Kendall1999

\Wood2010
}
\seealso{
More on methods based on summary statistics: 
\code{\link{abc}()},
\code{\link{nlf}},
\code{\link{probe}()},
\code{\link{probe_match}},
\code{\link{spect}()},
\code{\link{spect_match}}
}
\author{
Daniel C. Reuman, Aaron A. King
}
\concept{diagnostics}
\concept{summary statistic-based methods}
