% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregating.R
\name{as.aggre}
\alias{as.aggre}
\alias{as.aggre.data.frame}
\alias{as.aggre.data.table}
\alias{as.aggre.default}
\title{Coercion to Class \code{aggre}}
\usage{
as.aggre(x, values = NULL, by = setdiff(names(x), values), ...)

\method{as.aggre}{data.frame}(x, values = NULL, by = setdiff(names(x),
  values), ...)

\method{as.aggre}{data.table}(x, values = NULL, by = setdiff(names(x),
  values), ...)

\method{as.aggre}{default}(x, ...)
}
\arguments{
\item{x}{an R object to coerce to \code{aggre}; must be 
a \code{data.frame} or \code{data.table}}

\item{values}{a character string vector; the names of value variables}

\item{by}{a character string vector; the names of variables by which 
\code{values} have been tabulated}

\item{...}{arguments passed to or from methods}
}
\description{
Coerces an R object to an \code{aggre} object, identifying
the object as one containing aggregated counts, person-years and other
information.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: Coerces a \code{data.frame} to an \code{aggre} object

\item \code{data.table}: Coerces a \code{data.table} to an \code{aggre} object

\item \code{default}: Default method for \code{as.aggre} (stops computations
if no class-specific method found)
}}
\examples{
df <- data.frame(sex = rep(c("male", "female"), each = 5), 
                 obs = rpois(10, rep(7,5, each=5)), 
                 pyrs = rpois(10, lambda = 10000))
dt <- as.data.table(df)

df <- as.aggre(df, values = c("pyrs", "obs"), by = "sex")
dt <- as.aggre(dt, values = c("pyrs", "obs"), by = "sex")

class(df)
class(dt)

}
\author{
Joonas Miettinen
}
\seealso{
\code{\link{setaggre}} for modifying in place
}

