% Generated by roxygen2 (4.0.1): do not edit by hand
\name{asymmetricIntervals}
\alias{asymmetricIntervals}
\title{Compute Asymmetric Intervals}
\usage{
asymmetricIntervals(X, alpha = 0.05, k = 2, var = NULL, eps = 0.1)
}
\arguments{
\item{X}{is a matrix or data frame that contains the responses. Each column
represents a different population.}

\item{alpha}{denotes the significance level of the intervals to be formed.}

\item{k}{corresponds to the number of populations to be selected.}

\item{var}{denotes the common variance of the populations from which the data
is drawn. If this is NULL (the default), then the variance will be estimated
from the data. If it is known, then it should be provided as a scalar.}

\item{eps}{The grid size that is to be set up.}
}
\value{
This function returns a matrix with k rows and 3 columns. This
is similar to the output of the predict.lm function of R.
}
\description{
This function will compute asymmetric intervals for the
mean of the selected populations.
}
\details{
This function will compute the optimal lambda and c to be used to
shrink the interval for the selected populations.
}
\examples{
set.seed(18)
p <- 10; n <- 10
Xmat <- matrix(rnorm(p*n), nrow=n, ncol=p)
colnames(Xmat) <- paste("p.", 1:p, sep="")
asymmetricIntervals(Xmat, alpha=0.1, k=4)
}
\references{
Claudio Fuentes, George Casella and Martin Wells (2013). Interval estimation
for the mean of the selected populations (Submitted).

Vik Gopal and Claudio Fuentes (2013). kPop: An R package for
interval estimation of selected populations. useR! 2013.
}
\seealso{
\code{\link{bonferroniIntervals}}, \code{\link{bootstrapIntervals}}
}

