% Generated by roxygen2 (4.0.1): do not edit by hand
\name{optimalC}
\alias{optimalC}
\title{Derive the optimal c}
\usage{
optimalC(lambda, alpha = 0.05, min.loc = "infty", n, p, k = 1,
  var.known = TRUE)
}
\arguments{
\item{lambda}{The value of lambda under consideration. This must be a vector
with values between 0 and 1.}

\item{alpha}{The desired confidence coefficient.}

\item{min.loc}{The location of the minimum, either at 'zero' or 'infty'.}

\item{n}{The number of replications per population.}

\item{p}{The number of populations considered. This must be present if
min.loc is equal to 'zero'.}

\item{k}{The number of populations selected.}

\item{var.known}{A logical flag indicating if the variance of the
observations is known exactly. It is TRUE by default.}
}
\value{
The function returns a vector of length equal to that of lambda.
}
\description{
Derives the optimal c value for a given lambda.
}
\details{
This function will choose the correct equation to use for
and use 'uniroot' to find the c-value that corresponds to the desired
alpha-level.
}
\seealso{
\code{\link{optimalLambda}}
}

