% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printPopPCR.R
\name{printSummaryFit}
\alias{printSummaryFit}
\title{Print fitted mixture model estimates from popPCR}
\usage{
printSummaryFit(result.popPCR)
}
\arguments{
\item{result.popPCR}{returned value of popPCR()}
}
\description{
Summarizes the number of populations fitted and their estimate distribution parameters. If only 1 population was detected, then it is assumed and is identified to be a negative population. If 2 populations were detected, then the leftmost is identified as the Negative Population and the rightmost is the Positive Population. If 3 or more populations were detected, then the populations between the leftmost and the rightmost will be considered as Rain Populations; which are numbered to make it identifiable in case of multiple Rain Populations (i.e. Rain (1) and Rain (2)).
}
\examples{
result <- popPCR(x_twoPop, dist = "t")
printSummaryFit(result)
#    Output:
#        Results of fitting a 2-component t mixture model
#
#        Negative Population
#        Mix prop. : 0.1522
#        Mu        : 2136.7435
#        Sigma     : 4126.8357
#        Dof       : 12.3562
#
#        Positive Population
#        Mix prop. : 0.8478
#        Mu        : 7580.1275
#        Sigma     : 42621.1894
#        Dof       : 2.415
result <- popPCR(x_multiPop, dist = "t", maxComponents = 4)
printSummaryFit(result)
#     Output:
#        Results of fitting a 4-component t mixture model
#
#        Negative Population
#        Mix prop. : 0.6896
#        Mu        : 1452.1416
#        Sigma     : 12526.8931
#        Dof       : 21.3612
#
#        Rain (1) Population
#        Mix prop. : 0.142
#        Mu        : 2142.1118
#        Sigma     : 10762.5474
#        Dof       : 186.2947
#
#        Rain (2) Population
#        Mix prop. : 0.1457
#        Mu        : 5119.0039
#        Sigma     : 334959.2499
#        Dof       : 2.3626
#
#        Positive Population
#        Mix prop. : 0.0227
#        Mu        : 8505.9682
#        Sigma     : 192858.9044
#        Dof       : 149.8677
}
