% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bugs-funs.R
\name{diagnostic}
\alias{diagnostic}
\title{Check if a BUGS model has converged}
\usage{
diagnostic(data, threshold = 1.1)
}
\arguments{
\item{data}{a named \code{list} of BUGS outputs. The output of \code{\link[=fit_trend]{fit_trend()}} or
\code{\link[=read_bugs]{read_bugs()}}.}

\item{threshold}{a \code{numeric}.}
}
\value{
No return value.
}
\description{
From the output of the function \code{\link[=fit_trend]{fit_trend()}} (or \code{\link[=read_bugs]{read_bugs()}}), this
function checks if the estimation of all parameters of one (or several)
BUGS model has converged. This diagnostic is performed by comparing the
\code{Rhat} value of each parameter to a \code{threshold} (default is \code{1.1}). If some
\code{Rhat} values are greater than this threshold (no convergence), a message
listing problematic models is displayed.
}
\examples{
## Load Garamba raw dataset ----
file_path <- system.file("extdata", "garamba_survey.csv", 
                         package = "popbayes")
                         
garamba <- read.csv(file = file_path)

## Create temporary folder ----
temp_path <- tempdir()

## Format dataset ----
garamba_formatted <- popbayes::format_data(garamba, path = temp_path)
                                        
## Select one serie ----
a_buselaphus <- popbayes::filter_series(garamba_formatted, 
                                        location = "Garamba",
                                        species  = "Alcelaphus buselaphus")
\donttest{
## Fit population trends (requires JAGS) ----
a_buselaphus_mod <- popbayes::fit_trend(a_buselaphus, path = temp_path)

## Check for convergence ----
popbayes::diagnostic(a_buselaphus_mod)
}
}
