% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{species_info}
\alias{species_info}
\title{Species information dataset}
\format{
A \code{data.frame} with 15 rows (African mammals species) and the
following variables:
\describe{
\item{order}{the order of the species}
\item{family}{the family of the species}
\item{species}{the species binomial name}
\item{english}{the species English name}
\item{french}{the species French name}
\item{category}{the detectability category of the species. One of
\code{MLB} for Medium-sized Light and Brown species (20-150kg),
\code{LLB} for Large Light and Brown species (>150kg),
\code{LD} for Large Dark (>150kg), \code{Elephant}, and \code{Giraffe}}
\item{pref_field_method}{the preferred field method of the species. One of
\code{A} for Aerial counts, and \code{G} for Ground counts}
\item{conversion_A2G}{the conversion multiplicative factor (corresponding
to the detectability category) used to convert aerial to ground counts}
\item{rmax}{the maximum population growth rate}
}
}
\usage{
species_info
}
\description{
This dataset contains information about 15 African mammal species.
It can be used in the function \code{format_data()} to convert individual counts
estimated from a field method to a preferred field method. The field method
can be \code{A} (aerial counts) or \code{G} (ground counts). See \code{\link[=format_data]{format_data()}} for
further information. It also contains the maximum population growth rate
(i.e. the maximum change in log population size).

User can take this dataset as a template to add information for missing
species. Note that only \code{species}, \code{pref_field_method}, \code{conversion_A2G},
and \code{rmax} are required.
}
\examples{
data("species_info")
species_info
}
\keyword{datasets}
