% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{w_to_rmax}
\alias{w_to_rmax}
\title{Compute rmax from adult female body mass}
\usage{
w_to_rmax(w)
}
\arguments{
\item{w}{a numerical vector. Adult female body mass (in kg).}
}
\value{
A numerical vector of \code{rmax} values.
}
\description{
The demographic potential of a species is limited. The intrinsic rate of
increase \code{rmax} is the maximum increase in log population size that a
species can attain in a year. According to Sinclair (2003), it is related
to the body mass of adult females by: \eqn{1.375 \times W^{-0.315}}
}
\examples{
## Set adult female body mass ----
body_masses <- c(55, 127)

## Add species names ----
names(body_masses) <- c("Impala", "Tiang")

## Compute species rmax ----
w_to_rmax(body_masses)
}
\references{
Sinclair (2013) Mammal population regulation, keystone processes and
ecosystem dynamics. \emph{Philosophical Transactions: Biological Sciences},
\strong{358}, 1729-1740.
}
