% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitwise.r
\name{bitwise.ia}
\alias{bitwise.ia}
\title{Calculate the index of association between samples in a genlight object.}
\usage{
bitwise.ia(x, missing_match = TRUE, differences_only = FALSE, threads = 0)
}
\arguments{
\item{x}{a genlight object.}

\item{missing_match}{a boolean determining whether missing data should be
considered a match. If TRUE (default) missing data at a locus will match
with any data at that locus in each comparison. If FALSE, missing data at
a locus will cause all comparisons to return the maximum possible distance
at that locus (ie, if sample 1 has missing data at locus 1, and sample 2 
is heterozygous at locus 1, the distance at that locus will be 1. If sample
2 was heterozygous or missing at locus 1, the distance would be 2.}

\item{differences_only}{a boolean determining how distance should be counted
for diploids. Whether TRUE or FALSE the distance between a heterozygous locus
and a homozygous locus is 1. If FALSE (default) the distance between opposite
homozygous loci is 2. If TRUE that distance counts as 1, indicating only that
the two samples differ at that locus.}

\item{threads}{The maximum number of parallel threads to be used within this
function. A value of 0 (default) will attempt to use as many threads as there
are available cores/CPUs. In most cases this is ideal. A value of 1 will force
the function to run serially, which may increase stability on some systems.
Other values may be specified, but should be used with caution.}
}
\value{
Index of association representing the samples in this genlight object.
}
\description{
This function parses over a genlight object to calculate and return the
index of association for those samples.
}
\author{
Zhian N. Kamvar, Jonah C. Brooks
}
\keyword{internal}

