% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/read_genalexcel.R
\name{read.genalexcel}
\alias{read.genalexcel}
\title{Read GenAlEx formatted data from excel}
\usage{
read.genalexcel(x, sheet = 1, ...)
}
\arguments{
\item{x}{a path to your excel file}

\item{sheet}{the sheet in which your data is contained.}

\item{...}{any arguments to be passed on to \code{\link[poppr]{read.genalex}}}
}
\value{
a \code{\link[poppr]{genclone}} or \code{\link[adegenet]{genind}}
  object.
}
\description{
The \pkg{poppr} function \code{\link[poppr]{read.genalex}} provides a way to
read GenAlEx formatted data into R. The only stipulation is that the file
must be saved as a CSV text file beforehand. This function provides a wrapper
for \code{\link[poppr]{read.genalex}} and \code{\link[readxl]{read_excel}}
from the \pkg{readxl} package.
}
\examples{
nancy <- system.file("files/nancycats.xlsx", package = "popprxl")
nancy
read.genalexcel(nancy, sheet = 1, genclone = FALSE)
\dontrun{
nancy_ex_cols <- system.file("files/nancycats_extra_columns.xlsx", package = "popprxl")
# This will give a warning
read.genalexcel(nancy_ex_cols, sheet = 1, genclone = FALSE)
}
}
\author{
Zhian N. Kamvar
}
\seealso{
\code{\link[poppr]{read.genalex}}
}

