% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_estimate.R
\name{pp_estimate}
\alias{pp_estimate}
\title{Areal Interpolation of Population Data}
\usage{
pp_estimate(target, source, sid, spop, volume = NULL, point = FALSE, method)
}
\arguments{
\item{target}{an object of class \code{sf} representing individual
building polygons}

\item{source}{an object of class \code{sf} representing coarse polygon
features (such as census tracts or city blocks) including
population counts}

\item{sid}{source id}

\item{spop}{source population}

\item{volume}{target volume (height or number of floors)}

\item{point}{whether to use point geometries (TRUE/FALSE)}

\item{method}{available methods: awi, vwi}
}
\value{
An object of class sf including estimated population
    counts for target zone features using either awi or vwi methods. The estimated population
    counts are stored in a new column called pp_est.
}
\description{
Areal Interpolation of Population Data
}
\examples{
# read lib data
data('src')
data('trg')

# areal weighted interpolation - awi
pp_estimate(trg, src, sid = sid, spop = pop,
    method = awi)

# areal weighted interpolation - awi using point geometries
pp_estimate(trg, src, sid = sid, spop = pop,
    method = awi, point = TRUE)

# volume weighted interpolation - vwi
pp_estimate(trg, src, sid = sid, spop = pop,
    method = vwi, volume = floors)

# volume weighted interpolation - vwi using point geometries
pp_estimate(trg, src, sid = sid, spop = pop,
    method = vwi, volume = floors, point = TRUE)

}
