% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_datafile}
\alias{load_datafile}
\title{read in a raw datafile from the downloaded data or the GitHub repo}
\usage{
load_datafile(
  datafile,
  na.strings = "",
  path = get_default_data_path(),
  download_if_missing = TRUE,
  quiet = TRUE
)
}
\arguments{
\item{datafile}{the path to the datafile within the folder for Portal data}

\item{na.strings}{a character vector of strings which are to be
    interpreted as \code{\link{NA}} values.  Blank fields are also
    considered to be missing values in logical, integer, numeric and
    complex fields.  Note that the test happens \emph{after}
    white space is stripped from the input, so \code{na.strings}
    values may need their own white space stripped in advance.}

\item{path}{either the file path that contains the PortalData folder or
"repo", which then pulls data from the PortalData GitHub repository}

\item{download_if_missing}{if the specified file path doesn't have the
PortalData folder, then download it}

\item{quiet}{logical, whether to perform operations silently}
}
\description{
does checking for whether a particular datafile exists and then
  reads it in, using na_strings to determine what gets converted to NA. It
  can also download the dataset if it's missing locally.
}
