% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_postcard}
\alias{create_postcard}
\title{Create a new postcard}
\usage{
create_postcard(
  file = "index.Rmd",
  template = "jolla",
  create_dir = FALSE,
  edit = TRUE,
  create_image = TRUE
)
}
\arguments{
\item{file}{File name for the draft}

\item{template}{Template to use as the basis for the draft. This is either
the full path to a template directory or the name of a template directory
within the \code{rmarkdown/templates} directory of a package.}

\item{create_dir}{\code{TRUE} to create a new directory for the postcard
(defaults to \code{FALSE}).}

\item{edit}{\code{TRUE} to edit the template immediately}

\item{create_image}{\code{TRUE} to create a placeholder image
(defaults to \code{TRUE}).}
}
\description{
Create (and optionally edit) a new postcard.
}
\details{
Valid values for the \code{template} argument include \code{"jolla"}, \code{"jolla-blue"},
\code{"trestles"}, \code{"onofre"}, and \code{"solana"}.
}
\examples{
\dontrun{

postcards::create_postcard(template = "jolla")
postcards::create_postcard(template = "jolla-blue")
postcards::create_postcard(template = "trestles")
postcards::create_postcard(template = "onofre")
postcards::create_postcard(template = "solana")
}
}
