% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_model.R
\name{write_model}
\alias{write_model}
\title{Export BUGS/JAGS model from function to file}
\usage{
write_model(fun, file)
}
\arguments{
\item{fun}{A function object containing BUGS/JAGS model code}

\item{file}{A character vector of length == 1: the name of the file to write to}
}
\value{
Nothing, but \code{file} is written to disk.
}
\description{
Performs the same basic function as \code{\link[R2OpenBUGS:write.model]{R2OpenBUGS::write.model()}}
}
\details{
Performs the same basic function as \code{\link[R2OpenBUGS:write.model]{R2OpenBUGS::write.model()}},
but with slightly better output (scientific notation, spacing, etc.). The main reason it was created
for use in 'postpack' was to remove the need for using the 'R2OpenBUGS' package when not using OpenBUGS.
}
\examples{
if (interactive()) {
  # define some simple BUGS model as an R function
  # note the use of \%_\% to include a truncation
  mod = function() {
    # PRIORS
    mu ~ dnorm(0,0.001) \%_\% T(0,)
    sig ~ dunif(0,10)
    tau <- 1/sig^2

    # LIKELIHOOD
    for (i in 1:n) {
      y[i] ~ dnorm(mu, tau)
    }
  }

  # write model to a text file to be called by BUGS/JAGS
  write_model(mod, "model.txt")
}
}
