% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omit_std.R
\name{omit_std}
\alias{omit_std}
\title{Omit the internal standard from phase concentration data within a \code{powdRfps} or
\code{powdRafps} object}
\usage{
omit_std(x, ...)
}
\arguments{
\item{x}{A \code{powdRfps} or \code{powdRafps} object..}

\item{...}{other arguments}
}
\value{
a \code{powdRfps} or \code{powdRafps} object with components:
\item{tth}{a vector of the 2theta scale of the fitted data}
\item{fitted}{a vector of the fitted XRPD pattern}
\item{measured}{a vector of the original XRPD measurement (aligned and harmonised)}
\item{residuals}{a vector of the residuals (measured minus fitted)}
\item{phases}{a dataframe of the phases used to produce the fitted pattern and their concentrations}
\item{phases_grouped}{the phases dataframe grouped by phase_name and concentrations summed}
\item{obj}{named vector of the objective parameters summarising the quality of the fit}
\item{weighted_pure_patterns}{a dataframe of reference patterns used to produce the fitted pattern.
All patterns have been weighted according to the coefficients used in the fit}
\item{coefficients}{a named vector of coefficients used to produce the fitted pattern}
\item{inputs}{a list of input arguments used in the function call}
}
\description{
\code{omit_std} adjusts phase concentrations in a \code{powdRfps} or \code{powdRafps} object
(derived from \code{fps()} and \code{afps()}, respectively) by removing the concentrations of
the internal standard. Relevant information for the calculation is automatically
 extracted from \code{x$inputs$std} and \code{x$inputs$std_conc}. For more information see
 \code{?omit_std.powdRfps} and \code{omit_std.powdRafps}.
}
\examples{
\dontrun{
data(rockjock)
data(rockjock_mixtures)

rockjock_1 <- fps(lib = rockjock,
                  smpl = rockjock_mixtures$Mix1,
                  refs = c("ORDERED_MICROCLINE",
                           "LABRADORITE",
                           "KAOLINITE_DRY_BRANCH",
                           "MONTMORILLONITE_WYO",
                           "ILLITE_1M_RM30",
                           "CORUNDUM"),
                 std = "CORUNDUM",
                 align = 0.3,
                 std_conc = 20)

rockjock_1o <- omit_std(rockjock_1)

rockjock_a1 <- afps(lib = rockjock,
                    smpl = rockjock_mixtures$Mix1,
                    std = "CORUNDUM",
                    align = 0.3,
                    lod = 1,
                    std_conc = 20)

rockjock_a1o <- omit_std(rockjock_a1)

}
}
