% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drpc.R, R/prpc.R, R/qrpc.R, R/rrpc.R
\name{revpc}
\alias{revpc}
\alias{drpc}
\alias{revpc}
\alias{prpc}
\alias{revpc}
\alias{qrpc}
\alias{revpc}
\alias{rrpc}
\title{The Reversal Power Cauchy Distribution}
\usage{
drpc(x, lambda, mu = 0, sigma = 1)

prpc(q, lambda, mu = 0, sigma = 1)

qrpc(p, lambda, mu = 0, sigma = 1)

rrpc(n, lambda, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the reversal power Cauchy distribution with parameters mu, sigma and lambda.
}
\examples{
drpc(1, 1, 3, 4)
prpc(1, 1, 3, 4)
qrpc(0.2, 1, 3, 4)
rrpc(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.
}
