% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/conlnorm.R, R/def_conexp.R,
%   R/def_conpl.R, R/def_conweibull.R, R/def_disexp.R, R/def_dislnorm.R,
%   R/def_displ.R, R/def_dispois.R
\docType{methods}
\name{dist_rand}
\alias{dist_rand}
\alias{dist_rand,conlnorm-method}
\alias{dist_rand,conexp-method}
\alias{dist_rand,conpl-method}
\alias{dist_rand,conweibull-method}
\alias{dist_rand,disexp-method}
\alias{dist_rand,dislnorm-method}
\alias{dist_rand,displ-method}
\alias{dist_rand,dispois-method}
\title{Random number generation for the distribution objects}
\usage{
dist_rand(m, n)

\S4method{dist_rand}{conlnorm}(m, n = "numeric")

\S4method{dist_rand}{conexp}(m, n = "numeric")

\S4method{dist_rand}{conpl}(m, n = "numeric")

\S4method{dist_rand}{conweibull}(m, n = "numeric")

\S4method{dist_rand}{disexp}(m, n = "numeric")

\S4method{dist_rand}{dislnorm}(m, n = "numeric")

\S4method{dist_rand}{displ}(m, n = "numeric")

\S4method{dist_rand}{dispois}(m, n = "numeric")
}
\arguments{
\item{m}{a distribution object.}

\item{n}{number of observations to be generated.}
}
\value{
n random numbers
}
\description{
This is generic function for generating random numbers 
from the underlying distribution of the distribution reference objects.
This function generates \code{n} random numbers using the parameters 
and xmin values found in the associated reference object.
}
\note{
This method does *not* alter the internal state of
the distribution object.
}
\examples{
##########################################
#Create distribution object              #
##########################################
m = displ$new()
m$setXmin(7);m$setPars(2)

##########################################
#Generate five random numbers            #
##########################################
dist_rand(m, 5)
}
\seealso{
\code{\link{dist_cdf}}, \code{\link{dist_pdf}} 
and \code{\link{dist_ll}}
}
