% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoodnessOfFit.R
\name{assess_transformation}
\alias{assess_transformation}
\title{Assess normality of transformed data}
\usage{
assess_transformation(x, transformer, verbose = TRUE, ...)
}
\arguments{
\item{x}{A vector with numeric values that should be transformed to
normality.}

\item{transformer}{A transformer object created using
\code{find_transformation_parameters}.}

\item{verbose}{Sets verbosity of the fubction.}

\item{...}{Unused arguments.}
}
\value{
p-value for empirical goodness of fit test.
}
\description{
Not all data allows for a reasonable transformation to normality using power
transformation. For example, uniformly distributed data or multi-modal data
cannot be transformed to normality. This function computes a p-value for an
empirical goodness of fit test for central normality. A distribution is
centrally normal if the central 80\% of the data are approximately normally
distributed. The null-hypothesis is that the transformed distribution is
centrally normal.
}
\examples{
x <- exp(stats::rnorm(1000))
transformer <- find_transformation_parameters(
  x = x,
  method = "box_cox")

assess_transformation(
  x = x,
  transformer = transformer)
}
