% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crt.parallel.hte.R
\name{crt.parallel.hte}
\alias{crt.parallel.hte}
\title{Power for detecting treatment effect heterogeneity in a cluster randomized trial with a continuous outcome}
\usage{
crt.parallel.hte(
  m = NULL,
  J1 = NULL,
  J.ratio = 1,
  beta = NULL,
  sd.x = NULL,
  sd.yx = NULL,
  icc.x = 0,
  icc.yx = 0,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{m}{The number of subjects per cluster.}

\item{J1}{The number of clusters in arm 1.}

\item{J.ratio}{The ratio J2/J1 between the number of clusters in the two arms; defaults to 1 (equal clusters per arm).}

\item{beta}{The regression coefficient for the treatment-by-covariate interaction term.}

\item{sd.x}{The standard deviation of the covariate.}

\item{sd.yx}{The standard deviation of the outcome variable adjusting for the covariate.}

\item{icc.x}{The intraclass correlation coefficient for the covariate; defaults to 0.}

\item{icc.yx}{The intraclass correlation coefficient for the outcome adjusting for the covariate; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function performs power and sample size calculations for detecting a treatment-by-covariate
interaction effect in a two-arm cluster randomized trial
with a continuous outcome when the data will be analyzed using a linear mixed effects model
(random intercept for cluster and fixed effect for the treatment-by-covariate interaction).
Can solve for power, beta, J1, J.ratio or m.
}
\details{
This function is based on Yang et al (2020). If the covariate is a cluster-level covariate,
then icc.x should be set to 1 (the covariate does not vary within cluster).

Yang S, Li F, Starks MA, Hernandez AF, Mentz RJ, Choudhury KR (2020) Sample size requirements for detecting
treatment effect heterogeneity in cluster randomized trials. Statistics in Medicine 39:4218-4237.
}
\examples{
crt.parallel.hte(beta = 1, m = 27, J1 = 20, sd.x = 12.7, sd.yx = 71, icc.x = 0.08, icc.yx = 0.04)
}
