% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisite.cont.R
\name{multisite.cont}
\alias{multisite.cont}
\title{Power for test of average treatment effect in a multisite trial}
\usage{
multisite.cont(
  m = NULL,
  m.sd = 0,
  alloc.ratio = 1,
  J = NULL,
  delta = NULL,
  sd = 1,
  icc0 = NULL,
  icc1 = NULL,
  Rsq = 0,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{m}{The mean cluster/site size (number of participants per site).}

\item{m.sd}{The standard deviation of cluster/site sizes (provide if unequal number of participants per site);
defaults to 0.}

\item{alloc.ratio}{The allocation ratio of condition 2/condition 1 within site; defaults to 1.}

\item{J}{The total number of sites.}

\item{delta}{The difference between the condition 1 and condition 2 means under the alternative
minus the difference under the null hypothesis.}

\item{sd}{The total standard deviation of the outcome variable; defaults to 1.}

\item{icc0}{The proportion of total variance of the outcome attributable to variation in site-level means.}

\item{icc1}{The proportion of total variance of the outcome attributable to variation in the treatment effect across sites.}

\item{Rsq}{The estimated R^2 for regressing the outcome on the covariates; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs power and sample size calculations for a multisite trial with a
continuous (normal) outcome variable. Can solve for power, J, m or alpha.
}
\details{
In a multisite trial design, participants are randomized to conditions
within site.
}
\examples{
multisite.cont(m = 20, J = 10, delta = 3, sd = sqrt(40), icc0 = 0.1, icc1 = 0)
multisite.cont(m = 20, J = 10, delta = 3, sd = sqrt(48), icc0 = 0.095, icc1 = 0.048)
multisite.cont(m = 20, alloc.ratio = 1.5, J = 10, delta = 0.43, icc0 = 0.095, icc1 = 0.048)
multisite.cont(m = 10, J = NULL, delta = 0.5, sd = 1, icc0 = 0, icc1 = 0.05, power = 0.8)
multisite.cont(m = 20, m.sd = 5, J = 10, delta = 3, sd = sqrt(48), icc0 = 0.095, icc1 = 0.048)
multisite.cont(m = 20, J = 10, delta = 3, sd = sqrt(48), icc0 = 0.095,
icc1 = 0.048, Rsq = 0.5^2)
}
