% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiYEM2009}
\alias{ppiYEM2009}
\title{ppiYEM2009}
\format{A data frame with 8 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nlFood}}{Food poverty line}
\item{\code{extreme}}{USAID extreme poverty}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp300}}{Below $3.00 per day purchasing power parity (2005)}
\item{\code{ppp400}}{Below $4.00 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiYEM2009
}
\description{
Poverty Probability Index (PPI) lookup table for Yemen
}
\examples{
  # Access Yemen PPI table
  ppiYEM2009

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiYEM2009[ppiYEM2009$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiYEM2009, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiYEM2009[ppiYEM2009$score == ppiScore, "nl100"]

}
\keyword{datasets}
