% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.calc_decision_rules}
\alias{plot.calc_decision_rules}
\title{Plot method for \code{calc_decision_rules} objects}
\usage{
\method{plot}{calc_decision_rules}(x, plotly = TRUE, ...)
}
\arguments{
\item{x}{an object of class 'calc_decision_rules', usually returned by the
\code{calc_decision_rules} function}

\item{plotly}{should the plot be rendered in plotly? (Default is TRUE)}

\item{...}{unused}
}
\value{
In the one-sample case, a heatmap plot with number enrolled on the
x-axis and number of responses on the y-axis. In the two-sample case, a
grid of heatmap plots. Each plot is a combination of the number enrolled so
far in the experimental and control arms. The x-axis is the number of
responses in the control arm and the y-axis is the number of responses in
the experimental arm.
Green indicates combinations where the trial would proceed and red indicates
combinations where the trial would stop.
}
\description{
Returns a plot of decision rules from the results of
\code{calc_decision_rules} that can interactively show when to stop and
when to proceed at the various interim analyses
}
\examples{
\donttest{
set.seed(123)

# Two-sample case
dec_tbl <- calc_decision_rules(
n = cbind(seq(5, 25, 5), seq(5, 25, 5)), 
N = c(25, 25),
theta = 0.86, 
ppp = 0.2, 
p0 = NULL, 
direction = "greater", 
delta = 0,
prior = c(0.5, 0.5), 
S = 5000)

plot(dec_tbl)
}

}
