\name{allele2zeroone}
\alias{allele2zeroone}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Converts alleleobject into binary matrix}
\description{
  Converts \code{\link{alleleobject}} with codominant markers into
  binary matrix with a column for each marker.
}

\usage{
  allele2zeroone(alleleobject)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{alleleobject}{object of class \code{\link{alleleobject}} as
  generated by \code{\link{alleleinit}}.}
}
  
\value{
  A 0-1-matrix with individuals as rows and markers (alleles) as columns. 
}

\author{Christian Hennig
  \email{christian.hennig@unibo.it}
  \url{https://www.unibo.it/sitoweb/christian.hennig/en}}

\examples{
  data(tetragonula)
  ta <- alleleconvert(strmatrix=tetragonula[21:50,])
  tai <- alleleinit(allelematrix=ta)
  allele2zeroone(tai)
}
\keyword{manip}% at least one, from doc/KEYWORDS




