% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep.detrend.differencing}
\alias{prep.detrend.differencing}
\title{Detrend with differencing method}
\usage{
prep.detrend.differencing(tserie, nd = NULL)
}
\arguments{
\item{tserie}{a \code{ts} object}

\item{nd}{number of differences to apply. As default its value is NULL; in this case, the function will perform an automatic estimation of \code{nd}.}
}
\value{
A list is returned containing:
\item{tserie}{Transformed ts object.}
\item{nd}{Number of differencies applied.}
\item{firstvalues}{Lost values after differencing.}
}
\description{
Performs differencing with lag=1.
}
\details{
If no number of differences is specified, the function will make an estimation
of the number of differences needed based on unit root test provided by \code{forecast::ndiffs}
}
\examples{
prep.detrend.differencing(AirPassengers)
prep.detrend.differencing(AirPassengers,nd=2)
}
