% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze-preference-data.r
\name{fit_preference}
\alias{fit_preference}
\title{Fit the Preference Data Collected from a Two-stage Clinical Trial}
\usage{
fit_preference(outcome, random, treatment, strata, alpha = 0.05)
}
\arguments{
\item{outcome}{(numeric) individual trial outcomes.}

\item{random}{(logical) was this individual part of the random arm?}

\item{treatment}{(character, factor, or integer) which treatment an 
individual received}

\item{strata}{(optional integer) which strata the individual belongs to.}

\item{alpha}{(optional numeric) Level of significance (default=0.05)}
}
\description{
Computes the test statistics and p-values for the preference, 
selection, and treatment effects for the two-stage randomized trial using 
collected outcome, random, treatment, and strata values for specified
significance level.
}
\examples{
# Unstratified
outcome <- c(10, 8, 6, 10, 5, 8, 7, 6, 10, 12, 11, 6, 8, 10, 5, 7, 9, 12, 6,
             8, 9, 10, 7, 8,11)
random <- c(rep(FALSE, 13), rep(TRUE, 12))
treatment <- c(rep(1, 5), rep(2, 8), rep(1, 6), rep(2, 6))
fit_preference(outcome, random, treatment)

# Stratified
# Same data plus strata information.
strata <- c(1,1,2,2,2,1,1,1,1,2,2,2,2,1,1,1,2,2,2,1,1,1,2,2,2)
fit_preference(outcome, random, treatment, strata, alpha=0.1)
}
