\name{preseqR.nonreplace.sampling}
\alias{preseqR.nonreplace.sampling}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
    Sampling without replacement
}
\description{
    A histogram is generated by sampling without replacement from a given survey
}
\usage{
  preseqR.nonreplace.sampling(size, n)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{size}{
    An positive integer representing the size of the sub sample.
  }
  \item{n}{
    Frequencies of the number of individuals of each species captured. 
    The data must be a two-column table.  
    The first column is the frequency \eqn{j = 1,2,\dots}; and the second column
    is \eqn{n_j}, the number of species with \eqn{j} individuals observed in the
    sample. The first column must be sorted in an ascending order.
  }
}
\details{
  The function sample() in R is used to implement the sampling. We
  wrap the sample() function in a way that both input and output could be a histogram. 
}
\value{
    A two-column matrix. The first column is the frequency \eqn{j = 1,2,\dots}; the second column
    is \eqn{n_j}, the number of species with \eqn{j} individuals observed in the sample.
}
\references{
\url{https://stat.ethz.ch/R-manual/R-patched/library/base/html/sample.html}
}
\author{
  Chao Deng
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
## load library
library(preseqR)

## import data
data(FisherButterflyHist)

## setting a random seed
set.seed(123456)
## generate a sub sample with size 1e5
preseqR.nonreplace.sampling(size=1e3, FisherButterflyHist)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Sampling without replacement}
