% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{create_prediction}
\alias{create_prediction}
\title{Create a prediction on a specified experiment_version}
\usage{
create_prediction(
  experiment_version_id,
  dataset_id = NULL,
  folder_dataset_id = NULL,
  confidence = FALSE,
  best_single = FALSE,
  model_id = NULL,
  queries_dataset_id = NULL,
  queries_dataset_content_column = NULL,
  queries_dataset_id_column = NULL,
  queries_dataset_matching_id_description_column = NULL,
  top_k = NULL
)
}
\arguments{
\item{experiment_version_id}{id of the experiment_version, can be obtained with get_experiment_version_id().}

\item{dataset_id}{id of the dataset to start the prediction on, can be obtained with get_datasets().}

\item{folder_dataset_id}{id of the folder dataset to start prediction on, can be obtained with get_folders(). Only usefull for images use cases.}

\item{confidence}{boolean. If enable, confidence interval will be added to predictions.}

\item{best_single}{boolean. If enable, best single model (non blend) will be used for making predictions other wise, best model will be used unless if model_id is fed.}

\item{model_id}{id of the model to start the prediction on. If provided, it will overwrite the "best single" params.}

\item{queries_dataset_id}{id of the dataset containing queries (text-similarity).}

\item{queries_dataset_content_column}{name of the content column in the queries dataset (text-similarity).}

\item{queries_dataset_id_column}{name of the id column in the queries dataset (text-similarity).}

\item{queries_dataset_matching_id_description_column}{name of the column matching the id (text-similarity).}

\item{top_k}{number of class to retrieve (text-similarity).}
}
\value{
list - parsed prediction information.
}
\description{
Create a prediction on a specified experiment_version
}
