% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{inverse_prob_method}
\alias{inverse_prob_method}
\title{Inverse probability weighted method for estimating the top K eigenspaces}
\usage{
inverse_prob_method(X, K, trace.it = F, center = T, normalize = F)
}
\arguments{
\item{X}{a numeric matrix with \eqn{NA}s or "Incomplete" matrix object (see softImpute package)}

\item{K}{the number of principal components of interest}

\item{trace.it}{report the progress if \code{trace.it == TRUE}}

\item{center}{center each column of \code{X} if \code{center == TRUE}. 
The default value is \code{TRUE}.}

\item{normalize}{normalize each column of \code{X} such that its sample variance is 1 if \code{normalize == TRUE}. 
The default value is \code{False}.}
}
\value{
Columnwise centered matrix of the same dimension as \eqn{X}.
}
\description{
Inverse probability weighted method for estimating the top K eigenspaces
}
\examples{
X = matrix(1:30 + .1 * rnorm(30), 10, 3)
X[1, 1] = NA
X[2, 3] = NA
v_hat = inverse_prob_method(X, 1)
}
