% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_absolute_targets.R
\docType{methods}
\name{add_absolute_targets}
\alias{add_absolute_targets}
\alias{add_absolute_targets-method}
\alias{add_absolute_targets,ConservationProblem,numeric-method}
\alias{add_absolute_targets,ConservationProblem,character-method}
\alias{add_absolute_targets}
\alias{add_absolute_targets}
\alias{add_absolute_targets}
\title{Add Absolute Targets}
\usage{
add_absolute_targets(x, targets, ...) # x=ConservationProblem, targets=numeric

add_absolute_targets(x, targets, ...) # x=ConservationProblem, targets=character
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{targets}{\code{numeric} targets for features. If all features should
have the same target, \code{targets} can be a single number. Otherwise,
\code{targets} should be a \code{numeric} \code{vector} specifying a
target for each feature. Alternatively, if the features in
\code{x} were specified using a \code{data.frame} object, then
argument to \code{targets} may refer to a column name.}

\item{...}{not used.}
}
\value{
\code{\link{ConservationProblem-class}} object with the target added
  to it.
}
\description{
Set targets expressed as the actual value of features in the study area
that need to be represented in the prioritization. The argument to
\code{x} is treated the same as for \code{\link{add_relative_targets}}.
}
\details{
Note that with the exception of the maximum cover problem, targets must
be added to a \code{\link{problem}} or solving will return an error.


Targets are used to specify the minimum amount or proportion of a feature's
distribution that needs to be protected. All conservation planning problems
require adding targets with the exception of the maximum cover problem
(see \code{\link{add_max_cover_objective}}), which maximizes all features
in the solution and therefore does not require targets.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create base problem
p <- problem(sim_pu_raster, sim_features) \%>\%
     add_min_set_objective() \%>\%
     add_binary_decisions()

# create problem with targets to secure 3 amounts for each feature
p1 <- p \%>\% add_absolute_targets(3)

# create problem with varying targets for each feature
targets <- c(1, 2, 3, 2, 1)
p2 <- p \%>\% add_absolute_targets(targets)
\donttest{
# solve problem
s <- stack(solve(p1), solve(p2))

# plot solution
plot(s, main = c("targets for 3", "varying targets"), axes = FALSE,
     box = FALSE)
}

}
\seealso{
\code{\link{targets}}.
}
