% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch_matrix.R
\name{branch_matrix}
\alias{branch_matrix}
\alias{branch_matrix.default}
\alias{branch_matrix.phylo}
\title{Branch matrix}
\usage{
branch_matrix(x)

\method{branch_matrix}{default}(x)

\method{branch_matrix}{phylo}(x)
}
\arguments{
\item{x}{\code{\link[ape]{phylo}} tree object.}
}
\value{
\code{\link[Matrix]{dgCMatrix-class}} sparse matrix object. Each row
  corresponds to a different species. Each column corresponds to a different
  branch. Species that inherit from a given branch are denoted with a one.
}
\description{
Phylogenetic trees depict the evolutionary relationships between different
species. Each branch in a phylogenetic tree represents a period of
evolutionary history. Species that are connected to the same branch
both share that same period of evolutionary history. This function creates
a matrix that shows which species are connected with branch. In other words,
it creates a matrix that shows which periods of evolutionary history
each species experienced.
}
\examples{
# load data
data(sim_phylogeny)

# generate species by branch matrix
m <- branch_matrix(sim_phylogeny)

# plot data
if (requireNamespace("ape", quietly = TRUE)) {
  par(mfrow = c(1,2))
  plot(sim_phylogeny, main = "phylogeny")
  plot(raster(as.matrix(m)), main = "branch matrix", axes = FALSE,
       box = FALSE)
} else {
  message("the \\"ape\\" package needs to be installed to plot phylogenies")
}

}
