% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{parallel}
\alias{parallel}
\alias{set_number_of_threads}
\alias{get_number_of_threads}
\alias{set_number_of_threads}
\alias{get_number_of_threads}
\title{Number of threads for data processing}
\usage{
set_number_of_threads(x = 1L)

get_number_of_threads()
}
\arguments{
\item{x}{\code{integer} number of threads to use for processing.}
}
\value{
\describe{

  \item{get_number_of_threads}{\code{integer} number of threads.}

  \item{set_number_of_threads}{invisible \code{logical} indicating
    success.}

}
}
\description{
Set and get the number of threads used for processing data.
}
\details{
To stop processing data in parallel, set the number of
  threads to one. Note that neither of these functions influence the number
  of threads used when solving a conservation planning \code{\link{problem}}.
}
\examples{
# set number of threads to 2
set_number_of_threads(2)
# get number of threads
get_number_of_threads()

# reset number of threads to 1
set_number_of_threads(1)

# get number of threads
get_number_of_threads()

}
\seealso{
\code{\link{is.parallel}}, \code{\link{solvers}}.
}
