% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-estimate-linear.R
\name{cal_estimate_linear}
\alias{cal_estimate_linear}
\alias{cal_estimate_linear.data.frame}
\alias{cal_estimate_linear.tune_results}
\alias{cal_estimate_linear.grouped_df}
\title{Uses a linear regression model to calibrate numeric predictions}
\usage{
cal_estimate_linear(
  .data,
  truth = NULL,
  estimate = dplyr::matches("^.pred$"),
  smooth = TRUE,
  parameters = NULL,
  ...,
  .by = NULL
)

\method{cal_estimate_linear}{data.frame}(
  .data,
  truth = NULL,
  estimate = dplyr::matches("^.pred$"),
  smooth = TRUE,
  parameters = NULL,
  ...,
  .by = NULL
)

\method{cal_estimate_linear}{tune_results}(
  .data,
  truth = NULL,
  estimate = dplyr::matches("^.pred$"),
  smooth = TRUE,
  parameters = NULL,
  ...
)

\method{cal_estimate_linear}{grouped_df}(
  .data,
  truth = NULL,
  estimate = NULL,
  smooth = TRUE,
  parameters = NULL,
  ...
)
}
\arguments{
\item{.data}{Am ungrouped  \code{data.frame} object, or \code{tune_results} object,
that contains a prediction column.}

\item{truth}{The column identifier for the observed outcome data (that is
numeric). This should be an unquoted column name.}

\item{estimate}{Column identifier for the predicted values}

\item{smooth}{Applies to the linear models. It switches between a generalized
additive model using spline terms when \code{TRUE}, and simple linear regression
when \code{FALSE}.}

\item{parameters}{(Optional)  An optional tibble of tuning parameter values
that can be used to filter the predicted values before processing. Applies
only to \code{tune_results} objects.}

\item{...}{Additional arguments passed to the models or routines used to
calculate the new predictions.}

\item{.by}{The column identifier for the grouping variable. This should be
a single unquoted column name that selects a qualitative variable for
grouping. Default to \code{NULL}. When \code{.by = NULL} no grouping will take place.}
}
\description{
Uses a linear regression model to calibrate numeric predictions
}
\details{
This function uses existing modeling functions from other packages to create
the calibration:
\itemize{
\item \code{\link[stats:glm]{stats::glm()}} is used when \code{smooth} is set to \code{FALSE}
\item \code{\link[mgcv:gam]{mgcv::gam()}} is used when \code{smooth} is set to \code{TRUE}
}

These methods estimate the relationship in the unmodified predicted values
and then remove that trend when \code{\link[=cal_apply]{cal_apply()}} is invoked.
}
\examples{
library(dplyr)
library(ggplot2)

head(boosting_predictions_test)

# ------------------------------------------------------------------------------
# Before calibration

y_rng <- extendrange(boosting_predictions_test$outcome)

boosting_predictions_test |>
  ggplot(aes(outcome, .pred)) +
  geom_abline(lty = 2) +
  geom_point(alpha = 1 / 2) +
  geom_smooth(se = FALSE, col = "blue", linewidth = 1.2, alpha = 3 / 4) +
  coord_equal(xlim = y_rng, ylim = y_rng) +
  ggtitle("Before calibration")

# ------------------------------------------------------------------------------
# Smoothed trend removal

smoothed_cal <-
  boosting_predictions_oob |>
  # It will automatically identify the predicted value columns when the
  # standard tidymodels naming conventions are used.
  cal_estimate_linear(outcome)
smoothed_cal

boosting_predictions_test |>
  cal_apply(smoothed_cal) |>
  ggplot(aes(outcome, .pred)) +
  geom_abline(lty = 2) +
  geom_point(alpha = 1 / 2) +
  geom_smooth(se = FALSE, col = "blue", linewidth = 1.2, alpha = 3 / 4) +
  coord_equal(xlim = y_rng, ylim = y_rng) +
  ggtitle("After calibration")

}
\seealso{
\url{https://www.tidymodels.org/learn/models/calibration/},
\code{\link[=cal_validate_linear]{cal_validate_linear()}}
}
